import numpy as np
import Const
import itertools


"""棋盤クラス
"""
class Kiban:

  houkou = [  #勝利判定用方向データー 4方向×2方向
          [ [-1,-1],[1,1] ],
          [ [-1,0],[1,0] ],
          [ [-1,1],[1,-1] ],
          [ [0,-1],[0,1] ] 
  ]

  def __init__(self,masume):
    self.kiban = np.zeros((masume, masume),dtype=int)    
 
  def setKiban(self,x, y,state):  #手を打つ
    self.kiban[x][y] = state

  def checkFinal(self,x,y):       #勝利判定　x,y:打った座標
    kigou = self.kiban[x][y]

    """打った箇所から八方に探索し同じマークがいくつ並んでいるか確認
    """
    for key1,value1 in enumerate(self.houkou):  #4方向
      count = 1
      for key2,value2 in enumerate(self.houkou[key1]):  #2方向
        x2 = x
        y2 = y
        while True: #棋盤を超える、違うマーク、誰も打っていない、までループ
          x2 = x2 + self.houkou[key1][key2][0]  #打った座標から方向データ値分加算する
          y2 = y2 + self.houkou[key1][key2][1]

          if x2 < 0 or x2 >= Const.BANSU: #盤超えている?
            break
          if y2 < 0 or y2 >= Const.BANSU: #盤超えている?
            break
          if self.kiban[x2][y2] == Const.KUHAKU:  #誰も打っていない?
            break
          if self.kiban[x2][y2] != kigou: #違うマーク?
             break

          count += 1  #同じマークがあったのでカウントアップ

        if count >= Const.NARABE: #同じマークの数により勝利判定
          return kigou
    
    return Const.KUHAKU
  
  def disp(self): #棋盤表示
    print("----------------------------")
    for key1,value1 in enumerate(self.kiban):
      str = "|"
      for key2,value2 in enumerate(value1):
        str += Const.KIGOU[value2] + "|"
      print(str)

  def serchBlank(self): #打てる場所を探す
    ret = []
    for key1,value1 in enumerate(self.kiban):
      for key2,value2 in enumerate(value1):
        if value2 == Const.KUHAKU:
          ret.append([key1,key2]) 

    return ret
  
  def kibanToString(self):  #棋盤情報を辞書用のキーに変更
    ret = ""
    for key1,value1 in enumerate(self.kiban):
      for key2,value2 in enumerate(value1):
        ret += str(value2)

    return ret

  def checkKiban(self,x,y): #手が打てるかチェック
    if self.kiban[x][y] != Const.KUHAKU:
      return False
    return True

  def clear(self,masume): #棋盤クリア
    self.kiban = np.zeros((masume, masume),dtype=int)  
